/*
 Little Box of Poems
 by Giles Booth
 
 http://www.suppertime.co.uk/blogmywiki
 @blogmywiki

 not for commercial use
 if you modify this code for edcuational or charitable use
 please credit Giles Booth and/or @blogmywiki in printouts
 */

const int buttonPin = 2;     // the number of the pushbutton pin - doesn't change
int currState = 0;           // set variables to hold the state of the button
int prevState = 0;

#include "SoftwareSerial.h"
#include "Adafruit_Thermal.h" // you need to download this and put it in your Arduino library
#include "bmw.h"              // BlogMyWiki logo
#include "qr2.h"              // QR code graphic for my web site
#include <avr/pgmspace.h>     // I have no idea what this does

int buttonState = 0;     // variable for reading the button status
int printer_RX_Pin = 5;  // This is the green printer wire
int printer_TX_Pin = 6;  // This is the yellow printer wire

Adafruit_Thermal printer(printer_RX_Pin, printer_TX_Pin);

void setup() {
  pinMode(buttonPin, INPUT);    
  Serial.begin(19200);   // this is the baud rate of your printer - may vary
  pinMode(7, OUTPUT); digitalWrite(7, LOW);
  printer.begin();
}

void loop(){
  // read the state of the button:
  currState = digitalRead(buttonPin);
  if (currState != prevState)   // if something has changed, do something
{
  if (currState == HIGH) {    
    printPoem();
  }
  else {
    // if you want something to happen when the button is released, put it here
    // such as a beep, or a display saying 'your poem is on its way'
  }
prevState = currState;
}
}


void printPoem(){

  // put poem titles in order in here  
  char* myTitles[]={"In a Station of the Metro","This is just to say","Surprise","Moment","The Sick Rose","Women, Wine and Snuff"};
  
  // put poems in here in order
  // they must all be on the same line, in double quotes, separated by commas
  // use \n for a new line and \" to escape a quotation mark
  char* myPoems[]={"The apparition of these faces in the crowd;\nPetals on a wet, black bough.", "I have eaten\nthe plums\nthat were in\nthe icebox\n\nand which\nyou were probably\nsaving\nfor breakfast\n\nForgive me\nthey were delicious\nso sweet\nand so cold", "I lift the toilet seat\nas if it were the nest of a bird\nand i see cat tracks\nall around the edge of the bowl.",
"Clear moments are so short.\nThere is much more darkness.More\nocean than terra firma. More\nshadow than form.", "O rose, thou art sick!\nThe invisible worm,\nThat flies in the night,\nIn the howling storm,\n\nHas found out thy bed\nOf crimson joy,\nAnd his dark secret love\nDoes thy life destroy.","Give me women, wine and snuff\nUntil I cry out,\n\"hold, enough!\"You may do so sans objection\nTill the day of resurrection;\nFor, bless my beard, they aye shall be\nMy beloved Trinity."};

  // put author names & dates here, in order
  char* myAuthors[]={"Ezra Pound","William Carlos Williams","Richard Brautigan","Adam Zagajewski","William Blake","John Keats"};

  int poemChoice = random(0, 6);  // choose a random poem number between 0 and 5

  printer.doubleHeightOn();
  printer.println(myTitles[poemChoice]);  
  printer.doubleHeightOff();
  printer.boldOn(); 
  printer.println(myPoems[poemChoice]);   
  printer.boldOff();  
  printer.justify('R'); 
  printer.println(myAuthors[poemChoice]);     
  printer.justify('L');
  
  printer.printBitmap(bmw_width, bmw_height, bmw_data);    // print Blog My Wiki logo    
  printer.printBitmap(qr2_width, qr2_height, qr2_data);    // print QR code graphic
  printer.boldOn();
  printer.println("The Little Box of Poems");  
  printer.boldOff();
  printer.setSize('S');     // Setting the size adds a linefeed
  printer.println("www.suppertime.co.uk/blogmywiki");
  printer.println("@blogmywiki");  
  printer.feed(3);
  
  delay(2000);   // 2 second pause to help prevent multiple presses     
}
